CONTAINER OctaneSubMaterial
{

    NAME OctaneSubMaterial;

    //INCLUDE Mpreview;
    INCLUDE Mbase;

    GROUP Obaselist
    {

        //BOOL SUBMAT_MAT1_SOLO {}
        LONG SUBMAT_MAT1_TYPE
        {
            FIT_H;
            CYCLE
            {
                SUBMAT_TYPE_DIFFUSE;
                SUBMAT_TYPE_GLOSSY;
                SUBMAT_TYPE_SPECULAR;
                SUBMAT_TYPE_METAL;
                SUBMAT_TYPE_TOON;
                SUBMAT_TYPE_UNIVERSAL;
            }
        }
        LONG SUBMAT_MAT1_BRDF_MODEL
        {
            FIT_H;
            CYCLE
            {
                SUBMAT_BRDF_OCTANE;
                SUBMAT_BRDF_BECKMANN;
                SUBMAT_BRDF_GGX;
                SUBMAT_BRDF_WARD;
            }
        }

        //    GROUP
        //    {
        //        LAYOUTGROUP; COLUMNS 2; MATEDCOLUMNS 2;
        //        GROUP
        //        {
        //            BOOL SUBMAT_USE_COLOR       { PARENTMSG SUBMAT_MAT_DIF_GRP; }
        //            BOOL SUBMAT_USE_SPECULAR    { PARENTMSG SUBMAT_MAT_SPEC_GRP; }
        //        }
        //    }
    }

    //----------------------------- DIFFUSE -----------------------
    GROUP SUBMAT_MAT_DIF_GRP
    {
        DEFAULT 1;
        GROUP SUBMAT_MAT1_DIF_GRP
        {
            COLUMNS 2;
            VECTOR SUBMAT_MAT1_DIFFUSE_VALUE       { CUSTOMGUI OCTANE_COLORGUI; SCALE_H; SCALE_V; }
            BUTTON SUBMAT_MAT1_DIFFUSE_TEX_BTN     { }
        }
        SHADERLINK SUBMAT_MAT1_DIFFUSE_LINK        { OPEN; }
    }

    //---------------------------- SPECULAR -----------------------
    GROUP SUBMAT_MAT_SPEC_GRP
    {
        GROUP SUBMAT_MAT1_SPEC_GRP
        {
            COLUMNS 2;
            REAL SUBMAT_MAT1_SPECULAR_VALUE        { SCALE_H; MIN 0; STEP 0.01; MAX 1; CUSTOMGUI OCTNSLIDER; }
            BUTTON SUBMAT_MAT1_SPECULAR_TEX_BTN    {}
        }
        SHADERLINK SUBMAT_MAT1_SPECULAR_LINK       { OPEN; }
    }

    //-------------------------- SPECULAR MAP ---------------------
    GROUP SUBMAT_MAT_SPECMAP_GRP
    {
        GROUP SUBMAT_MAT1_SPECMAP_GRP
        {
            COLUMNS 2;
            REAL SUBMAT_MAT1_SPECMAP_VALUE        { SCALE_H; MIN 0; STEP 0.01; MAX 1; CUSTOMGUI OCTNSLIDER; }
            BUTTON SUBMAT_MAT1_SPECMAP_TEX_BTN    {}
        }
        SHADERLINK SUBMAT_MAT1_SPECMAP_LINK       { OPEN; }
    }

    //--------------------------- ROUGHNESS -----------------------
    GROUP SUBMAT_MAT_ROUGH_GRP
    {
        GROUP SUBMAT_MAT1_ROUGH_GRP
        {
            COLUMNS 2;
            REAL SUBMAT_MAT1_ROUGHNESS_VALUE       { SCALE_H; MIN 0; STEP 0.01; MAX 1; CUSTOMGUI OCTNSLIDER; }
            BUTTON SUBMAT_MAT1_ROUGHNESS_TEX_BTN   {}
        }
        SHADERLINK SUBMAT_MAT1_ROUGHNESS_LINK      { OPEN; }
    }

    //------------------------ ANISOTROPY -------------------------
    GROUP SUBMAT_MAT1_ANISO_GRP
    {
        REAL SUBMAT_MAT1_ANISOTROPY { SCALE_H; MIN -1; STEP 0.01; MAX 1;  CUSTOMGUI OCTNSLIDER; }

        GROUP SUBMAT_MAT1_ROT_GRP
        {
            COLUMNS 2;
            REAL SUBMAT_MAT1_ANISO_ROTATION_VALUE       { SCALE_H; MIN 0; STEP 0.01; MAX 1; CUSTOMGUI OCTNSLIDER; }
            BUTTON SUBMAT_MAT1_ANISO_ROTATION_TEX_BTN   {}
        }
        SHADERLINK SUBMAT_MAT1_ANISO_ROTATION_LINK    { SCALE_H; OPEN; }
    }

    //-------------------------- REFLECTION -----------------------
    GROUP SUBMAT_MAT_REFL_GRP
    {
        GROUP SUBMAT_MAT1_REFL_GRP
        {
            COLUMNS 2;
            REAL SUBMAT_MAT1_REFLECTION_VALUE      { SCALE_H; MIN 0; STEP 0.01; MAX 1; CUSTOMGUI OCTNSLIDER; }
            BUTTON SUBMAT_MAT1_REFLECTION_TEX_BTN  {}
        }
        SHADERLINK SUBMAT_MAT1_REFLECTION_LINK     { SCALE_H; OPEN; }
    }

    //-------------------------- SHEEN -----------------------
    GROUP SUBMAT_MAT_SHEEN_GRP
    {
        GROUP SUBMAT_MAT1_SHEEN_GRP
        {
            COLUMNS 2;
            REAL SUBMAT_MAT1_SHEEN_VALUE      { SCALE_H; MIN 0; STEP 0.01; MAX 1; CUSTOMGUI OCTNSLIDER; }
            BUTTON SUBMAT_MAT1_SHEEN_TEX_BTN  {}
        }
        SHADERLINK SUBMAT_MAT1_SHEEN_LINK   { SCALE_H; OPEN; }

        GROUP SUBMAT_SHEEN_ROUGH_GRP
        {
            COLUMNS 2;
            REAL SUBMAT_MAT1_SHEEN_ROUGH        { SCALE_H; MIN 0; STEP 0.01; MAX 1; CUSTOMGUI OCTNSLIDER; }
            BUTTON SUBMAT_MAT1_SHEEN_ROUGH_TEX_BTN   { ANIM OFF; }
        }
        SHADERLINK SUBMAT_MAT1_SHEEN_ROUGHNESS_LINK { OPEN; INPORT;}

        SHADERLINK SUBMAT_MAT1_SHEEN_BUMP_LINK { OPEN; INPORT;}
        SHADERLINK SUBMAT_MAT1_SHEEN_NORMAL_LINK { OPEN; INPORT;}
    }

    GROUP SUBMAT_MAT_COATING_GRP
    {
        GROUP SUBMAT_MAT1_COATING_GRP
        {
            COLUMNS 2;
            REAL SUBMAT_MAT1_COATING_VALUE      { SCALE_H; MIN 0; STEP 0.01; MAX 1; CUSTOMGUI OCTNSLIDER; }
            BUTTON SUBMAT_MAT1_COATING_TEX_BTN  {}
        }
        SHADERLINK SUBMAT_MAT1_COATING_LINK { OPEN; INPORT; }

        SEPARATOR {}

        GROUP SUBMAT_MAT1_COATING_ROUGH_GRP
        {
            COLUMNS 2;
            REAL SUBMAT_MAT1_COATING_ROUGHNESS  { SCALE_H; MIN 0.0; STEP 0.01; MAX 1.0; MAXSLIDER 1.0;  CUSTOMGUI OCTNSLIDER;; }
            BUTTON SUBMAT_MAT1_COATING_ROUGH_TEX_BTN  {}
        }
        SHADERLINK SUBMAT_MAT1_COATING_ROUGH_LINK { OPEN; INPORT; }

        REAL SUBMAT_MAT1_COATING_INDEX      { MIN 1.0; STEP 0.001; MAX 8.0;  CUSTOMGUI OCTNSLIDER; ANIM ON; }
        SHADERLINK SUBMAT_MAT1_COATING_BUMP_LINK { OPEN; INPORT;}
        SHADERLINK SUBMAT_MAT1_COATING_NORMAL_LINK { OPEN; INPORT;}
    }


    //------------------------ FILM WIDTH -------------------------
    GROUP SUBMAT_MAT1_FILM_GRP
    {
        REAL SUBMAT_MAT1_FILMINDEX    { SCALE_H; MIN 1; STEP 0.01; MAX 8;  CUSTOMGUI OCTNSLIDER;  }
        SHADERLINK SUBMAT_MAT1_FILMWIDTH_LINK    { SCALE_H; OPEN; }
        //BUTTON SUBMAT_MAT1_FILMWIDTH_TEX_BTN   {}
    }

    //--------------------------- BUMP ----------------------------
    GROUP SUBMAT_MAT1_BUMP_GRP
    {
        COLUMNS 2;
        SHADERLINK SUBMAT_MAT1_BUMP_LINK       { OPEN;  INPORT; }
        BUTTON SUBMAT_MAT1_BUMP_TEX_BTN        {}
    }

    //-------------------------- NORMAL ---------------------------
    GROUP SUBMAT_MAT1_NORMAL_GRP
    {
        COLUMNS 2;
        SHADERLINK SUBMAT_MAT1_NORMAL_LINK       { OPEN;  INPORT; }
        BUTTON SUBMAT_MAT1_NORMAL_TEX_BTN        {}
    }

    //------------------------- OPACITY ---------------------------
    GROUP SUBMAT_MAT_OPAC_GRP
    {
        GROUP SUBMAT_MAT1_OPAC_GRP
        {
            COLUMNS 2;
            REAL SUBMAT_MAT1_OPACITY_VALUE      { SCALE_H; MIN 0; STEP 0.01; MAX 1; CUSTOMGUI OCTNSLIDER; }
            BUTTON SUBMAT_MAT1_OPACITY_TEX_BTN  {}
        }
        SHADERLINK SUBMAT_MAT1_OPACITY_LINK    { OPEN;  INPORT; }
    }

    //----------------------- TRANSMISSION ------------------------
    GROUP SUBMAT_MAT1_TRNS_GRP
    {
        COLUMNS 2;
        SHADERLINK SUBMAT_MAT1_TRANSMISSION_LINK        { SCALE_H; OPEN; }
        BUTTON SUBMAT_MAT1_TRANSMISSION_TEX_BTN     {}
    }

    GROUP SUBMAT_MAT1_INDEX_GRP
    {
        REAL SUBMAT_MAT1_INDEX       { SCALE_H; MIN 1; STEP 0.01; MAX 8;  CUSTOMGUI OCTNSLIDER; }
        SHADERLINK SUBMAT_1_DIV_IOR_LINK { OPEN; INPORT; }
        SEPARATOR {}

        GROUP SUBMAT_MAT1_IORMODE_GRP
        {
            LONG SUBMAT_METALLIC_MODE
            {
                CYCLE
                {
                    SUBMAT_METAL_REFL_ARTISTIC;
                    SUBMAT_METAL_REFL_IOR_COLOR;
                    SUBMAT_METAL_REFL_RGB_IOR;
                }
            }

            GROUP SUBMAT_MAT1_INDEX2_GROUP
            {
                COLUMNS 2;
                REAL SUBMAT_MAT1_INDEX_N {  SCALE_H; MIN 0.0; STEP 0.001; MAX 8.0;  CUSTOMGUI OCTNSLIDER; ANIM ON; }
                REAL SUBMAT_MAT1_INDEX_K {  SCALE_H; MIN 0.0; STEP 0.001; MAX 8.0;  CUSTOMGUI OCTNSLIDER; ANIM ON; }
                REAL SUBMAT_MAT1_INDEX_GREEN_N {  SCALE_H; MIN 0.0; STEP 0.001; MAX 8.0;  CUSTOMGUI OCTNSLIDER; ANIM ON; }
                REAL SUBMAT_MAT1_INDEX_GREEN_K {  SCALE_H; MIN 0.0; STEP 0.001; MAX 8.0;  CUSTOMGUI OCTNSLIDER; ANIM ON; }
                REAL SUBMAT_MAT1_INDEX_BLUE_N {  SCALE_H; MIN 0.0; STEP 0.001; MAX 8.0;  CUSTOMGUI OCTNSLIDER; ANIM ON; }
                REAL SUBMAT_MAT1_INDEX_BLUE_K {  SCALE_H; MIN 0.0; STEP 0.001; MAX 8.0;  CUSTOMGUI OCTNSLIDER; ANIM ON; }
            }
        }
    }


    GROUP SUBMAT_MAT1_DISPERSION_GRP
    {
        REAL SUBMAT_MAT1_DISPERSION  { MIN 0.0; STEP 0.001; MAX 1;  CUSTOMGUI OCTNSLIDER; }
    }

    //------------------------- EMISSION --------------------------
    GROUP SUBMAT_MAT1_EMIS_GRP
    {
        GROUP
        {
            COLUMNS 3;
            BUTTON SUBMAT_MAT1_ADD_BB_EMIS    { ANIM OFF; }
            BUTTON SUBMAT_MAT1_ADD_TEX_EMIS   { ANIM OFF; }
        }

        GROUP SUBMAT_MAT1_EMIS_GRP1
        {
            COLUMNS 2;
            SHADERLINK SUBMAT_MAT1_EMISSION_LINK   { OPEN;  INPORT; ACCEPT {BlackBodyEmission;  TextureEmission; }}
            BUTTON SUBMAT_MAT1_EMISSION_TEX_BTN    {}
        }
    }

    //-------------------------- MEDIUM ---------------------------
    GROUP SUBMAT_MAT1_MEDIUM_GRP
    {
        GROUP
        {
            COLUMNS 3;
            BUTTON SUBMAT_MAT1_ADD_ABS_MEDIUM   { ANIM OFF; }
            BUTTON SUBMAT_MAT1_ADD_SCT_MEDIUM   { ANIM OFF; }
        }
        GROUP SUBMAT_MAT1_MEDIUM_GRP1
        {
            COLUMNS 2;
            SHADERLINK SUBMAT_MAT1_MEDIUM_LINK   { OPEN;  INPORT;  ACCEPT {ScatteringMedium; AbsorptionMedium;} }
            BUTTON SUBMAT_MAT1_MEDIUM_TEX_BTN    {}
        }
    }

    GROUP SUBMAT_MAT1_TOON_GROUP
    {
        LONG SUBMAT_MAT1_TOON_LIGHT_MODE
        {
            CYCLE
            {
                SUBMAT_MAT1_TOON_LM_TOON_LIGHTS;
                SUBMAT_MAT1_TOON_LM_CAMERA_LIGHTS;
            }
        }

        BUTTON SUBMAT_MAT1_ADD_TOON_DIFFUSE_RAMP_BTN   { ANIM OFF; }
        SHADERLINK SUBMAT_MAT1_TOON_DIFFUSE_RAMP  { OPEN;  INPORT; ACCEPT {ToonRampTexture; } }

        BUTTON SUBMAT_MAT1_ADD_TOON_SPECULAR_RAMP_BTN   { ANIM OFF; }
        SHADERLINK SUBMAT_MAT1_TOON_SPECULAR_RAMP { OPEN;  INPORT; ACCEPT {ToonRampTexture; } }

        SHADERLINK SUBMAT_MAT1_TOON_OUTLINE_COLOR { OPEN;  INPORT; }
        REAL SUBMAT_MAT1_TOON_OUTLINE_THICKNESS {  MIN 0.0; STEP 0.01; MAX 1.0; MAXSLIDER 1.0;  CUSTOMGUI OCTNSLIDER;; }
    }

    GROUP SUBMAT_MAT1_COMMON_GRP
    {
        BOOL    SUBMAT_MAT1_SMOOTH {}
        BOOL 	SUBMAT_MAT1_AFFECT_ALPHA {}
        REAL 	SUBMAT_MAT1_ROUNDED_EDGES {  MIN 0.0; STEP 0.001; MAX 100.0;  UNIT METER; }
        BOOL 	SUBMAT_MAT1_MATTE {}
        BOOL    SUBMAT_MAT1_FAKE_SHADOWS {   }
    }
}
